# Documentation

This folder contains documentation for SaaS OS Free Edition.

The goal of this documentation is to:

- Explain how the system works
- Define component contracts
- Support safe AI-assisted development
- Provide a clear starting point for implementation

---

## Structure

### Quick Reference

High-level guidance for:

- Getting started
- Using tokens
- Using Button and Input components
- Working with Cursor safely

This section is designed for fast onboarding.

---

### Engineering

Detailed specifications for:

- Component contracts
- Contract structure
- Usage boundaries

Contracts define meaning.

All UI behavior must be traceable to a documented contract.

---

## Free Edition Scope

SaaS OS Free Edition includes:

- Foundations
- Tokens
- Button contract
- Input contract
- Basic Cursor adapter

Advanced contracts, flows, and architectural documentation
are available in SaaS OS Pro.

---

## Important Principle

Documentation defines the system.

Code must conform to documentation.